'use client';

import Image from 'next/image';
import {
  Carousel,
  CarouselContent,
  CarouselItem,
} from '@/components/ui/carousel';
import Autoplay from 'embla-carousel-autoplay';
import { useLanguage } from '@/contexts/language-context';
import { PlaceHolderImages } from '@/lib/placeholder-images';
import { motion } from 'framer-motion';
import { Handshake } from 'lucide-react';
import { Card } from './ui/card';

export function Partners() {
  const { content } = useLanguage();
  const { partners } = content;

  const partnerImages = partners.logos.map(
    (partnerName) =>
      PlaceHolderImages.find((img) => img.id === `partner-${partnerName.toLowerCase().replace(/ /g, '-')}`)
  );

  return (
    <section id="partners" className="scroll-mt-20 relative overflow-hidden py-20 px-4 bg-gradient-to-br from-slate-50 via-white to-blue-50/20">
      <div className="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-[800px] h-[800px] bg-gradient-to-br from-blue-500/5 via-purple-500/5 to-transparent rounded-full blur-3xl"></div>

      <div className="container mx-auto relative z-10">
        <motion.div
            initial={{ opacity: 0, y: 20 }}
            whileInView={{ opacity: 1, y: 0 }}
            viewport={{ once: true }}
            transition={{ duration: 0.6 }}
            className="mx-auto max-w-2xl text-center"
        >
            <div className="inline-flex items-center gap-2 mb-4 px-4 py-2 rounded-full bg-gradient-to-r from-blue-500/10 via-purple-500/10 to-blue-500/10 border border-blue-500/20">
                <Handshake className="w-4 h-4 text-blue-600" />
                <span className="text-sm font-medium text-primary">Our Valued Partners</span>
            </div>
            <h2 className="font-headline text-3xl font-bold bg-gradient-to-r from-blue-600 via-purple-600 to-blue-600 bg-clip-text text-transparent sm:text-4xl">
              {partners.title}
            </h2>
            <div className="mt-4 mx-auto w-24 h-1 bg-gradient-to-r from-transparent via-purple-500 to-transparent rounded-full"></div>
        </motion.div>

        <div className="mt-16">
          <Carousel
            opts={{
              align: 'start',
              loop: true,
              slidesToScroll: 1,
            }}
            plugins={[
              Autoplay({
                delay: 3000,
                stopOnInteraction: false,
              }),
            ]}
            className="w-full"
          >
            <CarouselContent>
              {partnerImages.map((imageInfo, index) =>
                imageInfo ? (
                  <CarouselItem
                    key={index}
                    className="basis-1/2 sm:basis-1/3 md:basis-1/4 lg:basis-1/5"
                  >
                     <motion.div
                      initial={{ opacity: 0, y: 20 }}
                      whileInView={{ opacity: 1, y: 0 }}
                      viewport={{ once: true, amount: 0.5 }}
                      transition={{ duration: 0.5, delay: index * 0.1 }}
                      className="p-2"
                    >
                      <Card className="group relative h-28 flex items-center justify-center overflow-hidden rounded-2xl bg-white/60 backdrop-blur-md shadow-lg border border-slate-200/50 hover:shadow-xl transition-all duration-300 hover:-translate-y-1">
                        <div className="relative mx-auto h-12 w-28">
                          <Image
                            src={imageInfo.imageUrl}
                            alt={imageInfo.description}
                            fill
                            className="object-contain"
                            data-ai-hint={imageInfo.imageHint}
                          />
                        </div>
                         <div className="absolute inset-0 bg-gradient-to-br from-blue-500/20 to-purple-500/20 opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>
                      </Card>
                    </motion.div>
                  </CarouselItem>
                ) : null
              )}
            </CarouselContent>
          </Carousel>
        </div>
      </div>
    </section>
  );
}